<?php
/**
 * The template to display the background video in the header
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0.14
 */
$petsland_header_video = petsland_get_header_video();
$petsland_embed_video = '';
if (!empty($petsland_header_video) && !petsland_is_from_uploads($petsland_header_video)) {
	if (petsland_is_youtube_url($petsland_header_video) && preg_match('/[=\/]([^=\/]*)$/', $petsland_header_video, $matches) && !empty($matches[1])) {
		?><div id="background_video" data-youtube-code="<?php echo esc_attr($matches[1]); ?>"></div><?php
	} else {
		global $wp_embed;
		if (false && is_object($wp_embed)) {
			$petsland_embed_video = do_shortcode($wp_embed->run_shortcode( '[embed]' . trim($petsland_header_video) . '[/embed]' ));
			$petsland_embed_video = petsland_make_video_autoplay($petsland_embed_video);
		} else {
			$petsland_header_video = str_replace('/watch?v=', '/embed/', $petsland_header_video);
			$petsland_header_video = petsland_add_to_url($petsland_header_video, array(
				'feature' => 'oembed',
				'controls' => 0,
				'autoplay' => 1,
				'showinfo' => 0,
				'modestbranding' => 1,
				'wmode' => 'transparent',
				'enablejsapi' => 1,
				'origin' => home_url(),
				'widgetid' => 1
			));
			$petsland_embed_video = '<iframe src="' . esc_url($petsland_header_video) . '" width="1170" height="658" allowfullscreen="0" frameborder="0"></iframe>';
		}
		?><div id="background_video"><?php petsland_show_layout($petsland_embed_video); ?></div><?php
	}
}
?>