<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0.06
 */

$petsland_header_css = $petsland_header_image = '';
$petsland_header_video = petsland_get_header_video();
if (true || empty($petsland_header_video)) {
	$petsland_header_image = get_header_image();
	if (petsland_trx_addons_featured_image_override()) $petsland_header_image = petsland_get_current_mode_image($petsland_header_image);
}

$petsland_header_id = str_replace('header-custom-', '', petsland_get_theme_option("header_style"));
if ((int) $petsland_header_id == 0) {
	$petsland_header_id = petsland_get_post_id(array(
												'name' => $petsland_header_id,
												'post_type' => defined('TRX_ADDONS_CPT_LAYOUT_PT') ? TRX_ADDONS_CPT_LAYOUT_PT : 'cpt_layouts'
												)
											);
} else {
	$petsland_header_id = apply_filters('petsland_filter_get_translated_layout', $petsland_header_id);
}
$petsland_header_meta = get_post_meta($petsland_header_id, 'trx_addons_options', true);

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr($petsland_header_id); 
				?> top_panel_custom_<?php echo esc_attr(sanitize_title(get_the_title($petsland_header_id)));
				echo !empty($petsland_header_image) || !empty($petsland_header_video) 
					? ' with_bg_image' 
					: ' without_bg_image';
				if ($petsland_header_video!='') 
					echo ' with_bg_video';
				if ($petsland_header_image!='') 
					echo ' '.esc_attr(petsland_add_inline_css_class('background-image: url('.esc_url($petsland_header_image).');'));
				if (!empty($petsland_header_meta['margin']) != '') 
					echo ' '.esc_attr(petsland_add_inline_css_class('margin-bottom: '.esc_attr(petsland_prepare_css_value($petsland_header_meta['margin'])).';'));
				if (is_single() && has_post_thumbnail()) 
					echo ' with_featured_image';
				if (petsland_is_on(petsland_get_theme_option('header_fullheight'))) 
					echo ' header_fullheight petsland-full-height';
				?> scheme_<?php echo esc_attr(petsland_is_inherit(petsland_get_theme_option('header_scheme')) 
												? petsland_get_theme_option('color_scheme') 
												: petsland_get_theme_option('header_scheme'));
				?>"><?php

	// Background video
	if (!empty($petsland_header_video)) {
		get_template_part( 'templates/header-video' );
	}
		
	// Custom header's layout
	do_action('petsland_action_show_layout', $petsland_header_id);

	// Header widgets area
	get_template_part( 'templates/header-widgets' );
		
?></header>