<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0.10
 */

// Logo
if (petsland_is_on(petsland_get_theme_option('logo_in_footer'))) {
	$petsland_logo_image = '';
	if (petsland_is_on(petsland_get_theme_option('logo_retina_enabled')) && petsland_get_retina_multiplier(2) > 1)
		$petsland_logo_image = petsland_get_theme_option( 'logo_footer_retina' );
	if (empty($petsland_logo_image)) 
		$petsland_logo_image = petsland_get_theme_option( 'logo_footer' );
	$petsland_logo_text   = get_bloginfo( 'name' );
	if (!empty($petsland_logo_image) || !empty($petsland_logo_text)) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if (!empty($petsland_logo_image)) {
					$petsland_attr = petsland_getimagesize($petsland_logo_image);
					echo '<a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($petsland_logo_image).'" class="logo_footer_image" alt="'.esc_attr__('Image', 'petsland').'"'.(!empty($petsland_attr[3]) ? ' ' . wp_kses_data($petsland_attr[3]) : '').'></a>' ;
				} else if (!empty($petsland_logo_text)) {
					echo '<h1 class="logo_footer_text"><a href="'.esc_url(home_url('/')).'">' . esc_html($petsland_logo_text) . '</a></h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>