<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0.10
 */

// Copyright area
$petsland_footer_scheme =  petsland_is_inherit(petsland_get_theme_option('footer_scheme')) ? petsland_get_theme_option('color_scheme') : petsland_get_theme_option('footer_scheme');
$petsland_copyright_scheme = petsland_is_inherit(petsland_get_theme_option('copyright_scheme')) ? $petsland_footer_scheme : petsland_get_theme_option('copyright_scheme');
?> 
<div class="footer_copyright_wrap scheme_<?php echo esc_attr($petsland_copyright_scheme); ?>">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text"><?php
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$petsland_copyright = petsland_prepare_macros(petsland_get_theme_option('copyright'));
				if (!empty($petsland_copyright)) {
					// Replace {date_format} on the current date in the specified format
					if (preg_match("/(\\{[\\w\\d\\\\\\-\\:]*\\})/", $petsland_copyright, $petsland_matches)) {
						$petsland_copyright = str_replace($petsland_matches[1], date_i18n(str_replace(array('{', '}'), '', $petsland_matches[1])), $petsland_copyright);
					}
					// Display copyright
					echo wp_kses_data(nl2br($petsland_copyright));
				}
			?></div>
		</div>
	</div>
</div>
