<?php
/**
 * The template to display the Author bio
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */
?>

<div class="author_info scheme_default author vcard" itemprop="author" itemscope itemtype="http://schema.org/Person">

	<div class="author_avatar" itemprop="image">
		<?php 
		$petsland_mult = petsland_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 170*$petsland_mult );
		?>
	</div><!-- .author_avatar -->

	<div class="author_description">
		<h5 class="author_title" itemprop="name"><?php
			// Translators: Add the author's name in the <span> 
			echo wp_kses_data(sprintf(('%s'), '<span class="fn">'.get_the_author().'</span>'));
		?></h5>

		<div class="author_bio" itemprop="description">
			<?php echo wp_kses(wpautop(get_the_author_meta( 'description' )), 'petsland_kses_content'); ?>
			<?php do_action('petsland_action_user_meta'); ?>
		</div><!-- .author_bio -->

	</div><!-- .author_description -->

</div><!-- .author_info -->
