<?php
/* Elegro Crypto Payment support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'petsland_elegro_payment_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'petsland_elegro_payment_theme_setup9', 9 );
	function petsland_elegro_payment_theme_setup9() {
		if ( petsland_exists_elegro_payment() ) {
			add_filter( 'petsland_filter_merge_styles', 'petsland_elegro_payment_merge_styles' );
		}
		if ( is_admin() ) {
			add_filter( 'petsland_filter_tgmpa_required_plugins', 'petsland_elegro_payment_tgmpa_required_plugins' );
		}
	}
}


// Filter to add in the required plugins list
if ( !function_exists( 'petsland_elegro_payment_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('petsland_filter_tgmpa_required_plugins',	'petsland_elegro_payment_tgmpa_required_plugins');
	function petsland_elegro_payment_tgmpa_required_plugins($list=array()) {
		if (petsland_storage_isset('required_plugins', 'elegro-payment')) {
			$list[] = array(
				'name' 		=> petsland_storage_get_array('required_plugins', 'elegro-payment'),
				'slug' 		=> 'elegro-payment',
				'required' 	=> false
			);
		}
		return $list;
	}
}

// Check if this plugin installed and activated
if ( ! function_exists( 'petsland_exists_elegro_payment' ) ) {
	function petsland_exists_elegro_payment() {
		return class_exists( 'WC_Elegro_Payment' );
	}
}

// Merge custom styles
if ( ! function_exists( 'petsland_elegro_payment_merge_styles' ) ) {
	function petsland_elegro_payment_merge_styles( $list ) {
		$list[] = 'plugins/elegro-payment/elegro-payment.css';
		return $list;
	}
}