<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */

$petsland_columns = max(1, min(3, count(get_option( 'sticky_posts' ))));
$petsland_post_format = get_post_format();
$petsland_post_format = empty($petsland_post_format) ? 'standard' : str_replace('post-format-', '', $petsland_post_format);
$petsland_animation = petsland_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($petsland_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_'.esc_attr($petsland_post_format) ); ?>
	<?php echo (!petsland_is_off($petsland_animation) ? ' data-animation="'.esc_attr(petsland_get_animation_classes($petsland_animation)).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	petsland_show_post_featured(array(
		'thumb_size' => petsland_get_thumb_size($petsland_columns==1 ? 'big' : ($petsland_columns==2 ? 'med' : 'avatar'))
	));

	if ( !in_array($petsland_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			petsland_show_post_meta(apply_filters('petsland_filter_post_meta_args', array(), 'sticky', $petsland_columns));
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>