<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */

$petsland_post_format = get_post_format();
$petsland_post_format = empty($petsland_post_format) ? 'standard' : str_replace('post-format-', '', $petsland_post_format);
$petsland_animation = petsland_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_excerpt post_format_'.esc_attr($petsland_post_format) ); ?>
	<?php echo (!petsland_is_off($petsland_animation) ? ' data-animation="'.esc_attr(petsland_get_animation_classes($petsland_animation)).'"' : ''); ?>
	><?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	petsland_show_post_featured(array( 'thumb_size' => petsland_get_thumb_size( strpos(petsland_get_theme_option('body_style'), 'full')!==false ? 'full' : 'big' ) ));

	// Title and post meta
	if (get_the_title() != '') {
		?>
		<div class="post_header entry-header">
			<?php
			do_action('petsland_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h2 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );

			do_action('petsland_action_before_post_meta'); 

			// Post meta
			$petsland_components = petsland_is_inherit(petsland_get_theme_option_from_meta('meta_parts')) 
										? 'categories,date,counters'
										: petsland_array_get_keys_by_value(petsland_get_theme_option('meta_parts'));
			$petsland_counters = petsland_is_inherit(petsland_get_theme_option_from_meta('counters')) 
										? 'comments'
										: petsland_array_get_keys_by_value(petsland_get_theme_option('counters'));

			if (!empty($petsland_components))
				petsland_show_post_meta(apply_filters('petsland_filter_post_meta_args', array(
					'components' => $petsland_components,
					'counters' => $petsland_counters,
					'seo' => false
					), 'excerpt', 1)
				);
			?>
		</div><!-- .post_header --><?php
	}
	
	// Post content
	?><div class="post_content entry-content"><?php
		if (petsland_get_theme_option('blog_content') == 'fullpost') {
			// Post content area
			?><div class="post_content_inner"><?php
				the_content( '' );
			?></div><?php
			// Inner pages
			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'petsland' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'petsland' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

		} else {

			$petsland_show_learn_more = !in_array($petsland_post_format, array('link', 'aside', 'status', 'quote'));

			// Post content area
			?><div class="post_content_inner"><?php
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($petsland_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($petsland_post_format == 'quote') {
					if (($quote = petsland_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						petsland_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
			?></div><?php
			// More button
			if ( $petsland_show_learn_more ) {
				?><p><a class="more-link sc_button sc_button_size_small" href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e('Read More', 'petsland'); ?></a></p><?php
			}

		}
	?></div><!-- .entry-content -->
</article>