<?php
/**
 * The template to display posts in widgets and/or in the search results
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */

$petsland_post_id    = get_the_ID();
$petsland_post_date  = petsland_get_date();
$petsland_post_title = get_the_title();
$petsland_post_link  = get_permalink();
$petsland_post_author_id   = get_the_author_meta('ID');
$petsland_post_author_name = get_the_author_meta('display_name');
$petsland_post_author_url  = get_author_posts_url($petsland_post_author_id, '');

$petsland_args = get_query_var('petsland_args_widgets_posts');
$petsland_show_date = isset($petsland_args['show_date']) ? (int) $petsland_args['show_date'] : 1;
$petsland_show_image = isset($petsland_args['show_image']) ? (int) $petsland_args['show_image'] : 1;
$petsland_show_author = isset($petsland_args['show_author']) ? (int) $petsland_args['show_author'] : 1;
$petsland_show_counters = isset($petsland_args['show_counters']) ? (int) $petsland_args['show_counters'] : 1;
$petsland_show_categories = isset($petsland_args['show_categories']) ? (int) $petsland_args['show_categories'] : 1;

$petsland_output = petsland_storage_get('petsland_output_widgets_posts');

$petsland_post_counters_output = '';
if ( $petsland_show_counters ) {
	$petsland_post_counters_output = '<span class="post_info_item post_info_counters">'
								. petsland_get_post_counters('comments')
							. '</span>';
}


$petsland_output .= '<article class="post_item with_thumb">';

if ($petsland_show_image) {
	$petsland_post_thumb = get_the_post_thumbnail($petsland_post_id, petsland_get_thumb_size('tiny'), array(
		'alt' => the_title_attribute( array( 'echo' => false ) )
	));
	if ($petsland_post_thumb) $petsland_output .= '<div class="post_thumb">' . ($petsland_post_link ? '<a href="' . esc_url($petsland_post_link) . '">' : '') . ($petsland_post_thumb) . ($petsland_post_link ? '</a>' : '') . '</div>';
}

$petsland_output .= '<div class="post_content">'
			. ($petsland_show_categories 
					? '<div class="post_categories">'
						. petsland_get_post_categories()
						. $petsland_post_counters_output
						. '</div>' 
					: '')
			. '<h6 class="post_title">' . ($petsland_post_link ? '<a href="' . esc_url($petsland_post_link) . '">' : '') . ($petsland_post_title) . ($petsland_post_link ? '</a>' : '') . '</h6>'
			. apply_filters('petsland_filter_get_post_info', 
								'<div class="post_info">'
									. ($petsland_show_date 
										? '<span class="post_info_item post_info_posted">'
											. ($petsland_post_link ? '<a href="' . esc_url($petsland_post_link) . '" class="post_info_date">' : '') 
											. esc_html($petsland_post_date) 
											. ($petsland_post_link ? '</a>' : '')
											. '</span>'
										: '')
									. ($petsland_show_author 
										? '<span class="post_info_item post_info_posted_by">' 
											. esc_html__('by', 'petsland') . ' ' 
											. ($petsland_post_link ? '<a href="' . esc_url($petsland_post_author_url) . '" class="post_info_author">' : '') 
											. esc_html($petsland_post_author_name) 
											. ($petsland_post_link ? '</a>' : '') 
											. '</span>'
										: '')
									. (!$petsland_show_categories && $petsland_post_counters_output
										? $petsland_post_counters_output
										: '')
								. '</div>')
		. '</div>'
	. '</article>';
petsland_storage_set('petsland_output_widgets_posts', $petsland_output);
?>