<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */

// Header sidebar
$petsland_header_name = petsland_get_theme_option('header_widgets');
$petsland_header_present = !petsland_is_off($petsland_header_name) && is_active_sidebar($petsland_header_name);
if ($petsland_header_present) { 
	petsland_storage_set('current_sidebar', 'header');
	$petsland_header_wide = petsland_get_theme_option('header_wide');
	ob_start();
	if ( is_active_sidebar($petsland_header_name) ) {
		dynamic_sidebar($petsland_header_name);
	}
	$petsland_widgets_output = ob_get_contents();
	ob_end_clean();
	if (!empty($petsland_widgets_output)) {
		$petsland_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $petsland_widgets_output);
		$petsland_need_columns = strpos($petsland_widgets_output, 'columns_wrap')===false;
		if ($petsland_need_columns) {
			$petsland_columns = max(0, (int) petsland_get_theme_option('header_columns'));
			if ($petsland_columns == 0) $petsland_columns = min(6, max(1, substr_count($petsland_widgets_output, '<aside ')));
			if ($petsland_columns > 1)
				$petsland_widgets_output = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($petsland_columns).' widget ', $petsland_widgets_output);
			else
				$petsland_need_columns = false;
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo !empty($petsland_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php 
				if (!$petsland_header_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($petsland_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'petsland_action_before_sidebar' );
				petsland_show_layout($petsland_widgets_output);
				do_action( 'petsland_action_after_sidebar' );
				if ($petsland_need_columns) {
					?></div>	<!-- /.columns_wrap --><?php
				}
				if (!$petsland_header_wide) {
					?></div>	<!-- /.content_wrap --><?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>