<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0.10
 */

// Footer sidebar
$petsland_footer_name = petsland_get_theme_option('footer_widgets');
$petsland_footer_present = !petsland_is_off($petsland_footer_name) && is_active_sidebar($petsland_footer_name);
if ($petsland_footer_present) { 
	petsland_storage_set('current_sidebar', 'footer');
	$petsland_footer_wide = petsland_get_theme_option('footer_wide');
	ob_start();
	if ( is_active_sidebar($petsland_footer_name) ) {
		dynamic_sidebar($petsland_footer_name);
	}
	$petsland_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($petsland_out)) {
		$petsland_out = preg_replace("/<\\/aside>[\r\n\s]*<aside/", "</aside><aside", $petsland_out);
		$petsland_need_columns = true;	//or check: strpos($petsland_out, 'columns_wrap')===false;
		if ($petsland_need_columns) {
			$petsland_columns = max(0, (int) petsland_get_theme_option('footer_columns'));
			if ($petsland_columns == 0) $petsland_columns = min(4, max(1, substr_count($petsland_out, '<aside ')));
			if ($petsland_columns > 1)
				$petsland_out = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($petsland_columns).' widget ', $petsland_out);
			else
				$petsland_need_columns = false;
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo !empty($petsland_footer_wide) ? ' footer_fullwidth' : ''; ?> sc_layouts_row  sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner">
				<?php 
				if (!$petsland_footer_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($petsland_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'petsland_action_before_sidebar' );
				petsland_show_layout($petsland_out);
				do_action( 'petsland_action_after_sidebar' );
				if ($petsland_need_columns) {
					?></div><!-- /.columns_wrap --><?php
				}
				if (!$petsland_footer_wide) {
					?></div><!-- /.content_wrap --><?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
?>