<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0.10
 */

$petsland_footer_scheme =  petsland_is_inherit(petsland_get_theme_option('footer_scheme')) ? petsland_get_theme_option('color_scheme') : petsland_get_theme_option('footer_scheme');
$petsland_footer_id = str_replace('footer-custom-', '', petsland_get_theme_option("footer_style"));
if ((int) $petsland_footer_id == 0) {
	$petsland_footer_id = petsland_get_post_id(array(
												'name' => $petsland_footer_id,
												'post_type' => defined('TRX_ADDONS_CPT_LAYOUT_PT') ? TRX_ADDONS_CPT_LAYOUT_PT : 'cpt_layouts'
												)
											);
} else {
	$petsland_footer_id = apply_filters('petsland_filter_get_translated_layout', $petsland_footer_id);
}
$petsland_footer_meta = get_post_meta($petsland_footer_id, 'trx_addons_options', true);
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr($petsland_footer_id); 
						?> footer_custom_<?php echo esc_attr(sanitize_title(get_the_title($petsland_footer_id))); 
						if (!empty($petsland_footer_meta['margin']) != '') 
							echo ' '.esc_attr(petsland_add_inline_css_class('margin-top: '.esc_attr(petsland_prepare_css_value($petsland_footer_meta['margin'])).';'));
						?> scheme_<?php echo esc_attr($petsland_footer_scheme); 
						?>">
	<?php
    // Custom footer's layout
    do_action('petsland_action_show_layout', $petsland_footer_id);
	?>
</footer><!-- /.footer_wrap -->
