<?php
/**
 * The template for homepage posts with "Classic" style
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */

petsland_storage_set('blog_archive', true);

// Load scripts for 'Masonry' layout
if (substr(petsland_get_theme_option('blog_style'), 0, 7) == 'masonry') {
	wp_enqueue_script( 'imagesloaded' );
	wp_enqueue_script( 'masonry' );
	wp_enqueue_script( 'classie', petsland_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
	wp_enqueue_script( 'petsland-gallery-script', petsland_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );
}

get_header(); 

if (have_posts()) {

	petsland_show_layout(get_query_var('blog_archive_start'));

	$petsland_classes = 'posts_container '
						. (substr(petsland_get_theme_option('blog_style'), 0, 7) == 'classic' ? 'columns_wrap columns_padding_bottom' : 'masonry_wrap');
	$petsland_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$petsland_sticky_out = petsland_get_theme_option('sticky_style')=='columns' 
							&& is_array($petsland_stickies) && count($petsland_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($petsland_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	if (!$petsland_sticky_out) {
		if (petsland_get_theme_option('first_post_large') && !is_paged() && !in_array(petsland_get_theme_option('body_style'), array('fullwide', 'fullscreen'))) {
			the_post();
			get_template_part( 'content', 'excerpt' );
		}
		
		?><div class="<?php echo esc_attr($petsland_classes); ?>"><?php
	}
	while ( have_posts() ) { the_post(); 
		if ($petsland_sticky_out && !is_sticky()) {
			$petsland_sticky_out = false;
			?></div><div class="<?php echo esc_attr($petsland_classes); ?>"><?php
		}
		get_template_part( 'content', $petsland_sticky_out && is_sticky() ? 'sticky' : 'classic' );
	}
	
	?></div><?php

	petsland_show_pagination();

	petsland_show_layout(get_query_var('blog_archive_end'));

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>