<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Get theme variable
if (!function_exists('petsland_storage_get')) {
	function petsland_storage_get($var_name, $default='') {
		global $PETSLAND_STORAGE;
		return isset($PETSLAND_STORAGE[$var_name]) ? $PETSLAND_STORAGE[$var_name] : $default;
	}
}

// Set theme variable
if (!function_exists('petsland_storage_set')) {
	function petsland_storage_set($var_name, $value) {
		global $PETSLAND_STORAGE;
		$PETSLAND_STORAGE[$var_name] = $value;
	}
}

// Check if theme variable is empty
if (!function_exists('petsland_storage_empty')) {
	function petsland_storage_empty($var_name, $key='', $key2='') {
		global $PETSLAND_STORAGE;
		if (!empty($key) && !empty($key2))
			return empty($PETSLAND_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return empty($PETSLAND_STORAGE[$var_name][$key]);
		else
			return empty($PETSLAND_STORAGE[$var_name]);
	}
}

// Check if theme variable is set
if (!function_exists('petsland_storage_isset')) {
	function petsland_storage_isset($var_name, $key='', $key2='') {
		global $PETSLAND_STORAGE;
		if (!empty($key) && !empty($key2))
			return isset($PETSLAND_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return isset($PETSLAND_STORAGE[$var_name][$key]);
		else
			return isset($PETSLAND_STORAGE[$var_name]);
	}
}

// Inc/Dec theme variable with specified value
if (!function_exists('petsland_storage_inc')) {
	function petsland_storage_inc($var_name, $value=1) {
		global $PETSLAND_STORAGE;
		if (empty($PETSLAND_STORAGE[$var_name])) $PETSLAND_STORAGE[$var_name] = 0;
		$PETSLAND_STORAGE[$var_name] += $value;
	}
}

// Concatenate theme variable with specified value
if (!function_exists('petsland_storage_concat')) {
	function petsland_storage_concat($var_name, $value) {
		global $PETSLAND_STORAGE;
		if (empty($PETSLAND_STORAGE[$var_name])) $PETSLAND_STORAGE[$var_name] = '';
		$PETSLAND_STORAGE[$var_name] .= $value;
	}
}

// Get array (one or two dim) element
if (!function_exists('petsland_storage_get_array')) {
	function petsland_storage_get_array($var_name, $key, $key2='', $default='') {
		global $PETSLAND_STORAGE;
		if (empty($key2))
			return !empty($var_name) && !empty($key) && isset($PETSLAND_STORAGE[$var_name][$key]) ? $PETSLAND_STORAGE[$var_name][$key] : $default;
		else
			return !empty($var_name) && !empty($key) && isset($PETSLAND_STORAGE[$var_name][$key][$key2]) ? $PETSLAND_STORAGE[$var_name][$key][$key2] : $default;
	}
}

// Set array element
if (!function_exists('petsland_storage_set_array')) {
	function petsland_storage_set_array($var_name, $key, $value) {
		global $PETSLAND_STORAGE;
		if (!isset($PETSLAND_STORAGE[$var_name])) $PETSLAND_STORAGE[$var_name] = array();
		if ($key==='')
			$PETSLAND_STORAGE[$var_name][] = $value;
		else
			$PETSLAND_STORAGE[$var_name][$key] = $value;
	}
}

// Set two-dim array element
if (!function_exists('petsland_storage_set_array2')) {
	function petsland_storage_set_array2($var_name, $key, $key2, $value) {
		global $PETSLAND_STORAGE;
		if (!isset($PETSLAND_STORAGE[$var_name])) $PETSLAND_STORAGE[$var_name] = array();
		if (!isset($PETSLAND_STORAGE[$var_name][$key])) $PETSLAND_STORAGE[$var_name][$key] = array();
		if ($key2==='')
			$PETSLAND_STORAGE[$var_name][$key][] = $value;
		else
			$PETSLAND_STORAGE[$var_name][$key][$key2] = $value;
	}
}

// Merge array elements
if (!function_exists('petsland_storage_merge_array')) {
	function petsland_storage_merge_array($var_name, $key, $value) {
		global $PETSLAND_STORAGE;
		if (!isset($PETSLAND_STORAGE[$var_name])) $PETSLAND_STORAGE[$var_name] = array();
		if ($key==='')
			$PETSLAND_STORAGE[$var_name] = array_merge($PETSLAND_STORAGE[$var_name], $value);
		else
			$PETSLAND_STORAGE[$var_name][$key] = array_merge($PETSLAND_STORAGE[$var_name][$key], $value);
	}
}

// Add array element after the key
if (!function_exists('petsland_storage_set_array_after')) {
	function petsland_storage_set_array_after($var_name, $after, $key, $value='') {
		global $PETSLAND_STORAGE;
		if (!isset($PETSLAND_STORAGE[$var_name])) $PETSLAND_STORAGE[$var_name] = array();
		if (is_array($key))
			petsland_array_insert_after($PETSLAND_STORAGE[$var_name], $after, $key);
		else
			petsland_array_insert_after($PETSLAND_STORAGE[$var_name], $after, array($key=>$value));
	}
}

// Add array element before the key
if (!function_exists('petsland_storage_set_array_before')) {
	function petsland_storage_set_array_before($var_name, $before, $key, $value='') {
		global $PETSLAND_STORAGE;
		if (!isset($PETSLAND_STORAGE[$var_name])) $PETSLAND_STORAGE[$var_name] = array();
		if (is_array($key))
			petsland_array_insert_before($PETSLAND_STORAGE[$var_name], $before, $key);
		else
			petsland_array_insert_before($PETSLAND_STORAGE[$var_name], $before, array($key=>$value));
	}
}

// Push element into array
if (!function_exists('petsland_storage_push_array')) {
	function petsland_storage_push_array($var_name, $key, $value) {
		global $PETSLAND_STORAGE;
		if (!isset($PETSLAND_STORAGE[$var_name])) $PETSLAND_STORAGE[$var_name] = array();
		if ($key==='')
			array_push($PETSLAND_STORAGE[$var_name], $value);
		else {
			if (!isset($PETSLAND_STORAGE[$var_name][$key])) $PETSLAND_STORAGE[$var_name][$key] = array();
			array_push($PETSLAND_STORAGE[$var_name][$key], $value);
		}
	}
}

// Pop element from array
if (!function_exists('petsland_storage_pop_array')) {
	function petsland_storage_pop_array($var_name, $key='', $defa='') {
		global $PETSLAND_STORAGE;
		$rez = $defa;
		if ($key==='') {
			if (isset($PETSLAND_STORAGE[$var_name]) && is_array($PETSLAND_STORAGE[$var_name]) && count($PETSLAND_STORAGE[$var_name]) > 0) 
				$rez = array_pop($PETSLAND_STORAGE[$var_name]);
		} else {
			if (isset($PETSLAND_STORAGE[$var_name][$key]) && is_array($PETSLAND_STORAGE[$var_name][$key]) && count($PETSLAND_STORAGE[$var_name][$key]) > 0) 
				$rez = array_pop($PETSLAND_STORAGE[$var_name][$key]);
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if (!function_exists('petsland_storage_inc_array')) {
	function petsland_storage_inc_array($var_name, $key, $value=1) {
		global $PETSLAND_STORAGE;
		if (!isset($PETSLAND_STORAGE[$var_name])) $PETSLAND_STORAGE[$var_name] = array();
		if (empty($PETSLAND_STORAGE[$var_name][$key])) $PETSLAND_STORAGE[$var_name][$key] = 0;
		$PETSLAND_STORAGE[$var_name][$key] += $value;
	}
}

// Concatenate array element with specified value
if (!function_exists('petsland_storage_concat_array')) {
	function petsland_storage_concat_array($var_name, $key, $value) {
		global $PETSLAND_STORAGE;
		if (!isset($PETSLAND_STORAGE[$var_name])) $PETSLAND_STORAGE[$var_name] = array();
		if (empty($PETSLAND_STORAGE[$var_name][$key])) $PETSLAND_STORAGE[$var_name][$key] = '';
		$PETSLAND_STORAGE[$var_name][$key] .= $value;
	}
}

// Call object's method
if (!function_exists('petsland_storage_call_obj_method')) {
	function petsland_storage_call_obj_method($var_name, $method, $param=null) {
		global $PETSLAND_STORAGE;
		if ($param===null)
			return !empty($var_name) && !empty($method) && isset($PETSLAND_STORAGE[$var_name]) ? $PETSLAND_STORAGE[$var_name]->$method(): '';
		else
			return !empty($var_name) && !empty($method) && isset($PETSLAND_STORAGE[$var_name]) ? $PETSLAND_STORAGE[$var_name]->$method($param): '';
	}
}

// Get object's property
if (!function_exists('petsland_storage_get_obj_property')) {
	function petsland_storage_get_obj_property($var_name, $prop, $default='') {
		global $PETSLAND_STORAGE;
		return !empty($var_name) && !empty($prop) && isset($PETSLAND_STORAGE[$var_name]->$prop) ? $PETSLAND_STORAGE[$var_name]->$prop : $default;
	}
}
?>