<?php
/**
 * The template to display blog archive
 *
 * @package WordPress
 * @subpackage PETSLAND
 * @since PETSLAND 1.0
 */

/*
Template Name: Blog archive
*/

/**
 * Make page with this template and put it into menu
 * to display posts as blog archive
 * You can setup output parameters (blog style, posts per page, parent category, etc.)
 * in the Theme Options section (under the page content)
 * You can build this page in the WordPress editor or any Page Builder to make custom page layout:
 * just insert %%CONTENT%% in the desired place of content
 */

// Get template page's content
$petsland_content = '';
$petsland_blog_archive_mask = '%%CONTENT%%';
$petsland_blog_archive_subst = sprintf('<div class="blog_archive">%s</div>', $petsland_blog_archive_mask);
if ( have_posts() ) {
	the_post();
	if (($petsland_content = apply_filters('the_content', get_the_content())) != '') {
		if (($petsland_pos = strpos($petsland_content, $petsland_blog_archive_mask)) !== false) {
			$petsland_content = preg_replace('/(\<p\>\s*)?'.$petsland_blog_archive_mask.'(\s*\<\/p\>)/i', $petsland_blog_archive_subst, $petsland_content);
		} else
			$petsland_content .= $petsland_blog_archive_subst;
		$petsland_content = explode($petsland_blog_archive_mask, $petsland_content);
		// Add VC custom styles to the inline CSS
		$vc_custom_css = get_post_meta( get_the_ID(), '_wpb_shortcodes_custom_css', true );
		if ( !empty( $vc_custom_css ) ) petsland_add_inline_css(strip_tags($vc_custom_css));
	}
}

// Prepare args for a new query
$petsland_args = array(
	'post_status' => current_user_can('read_private_pages') && current_user_can('read_private_posts') ? array('publish', 'private') : 'publish'
);
$petsland_args = petsland_query_add_posts_and_cats($petsland_args, '', petsland_get_theme_option('post_type'), petsland_get_theme_option('parent_cat'));
$petsland_page_number = get_query_var('paged') ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);
if ($petsland_page_number > 1) {
	$petsland_args['paged'] = $petsland_page_number;
	$petsland_args['ignore_sticky_posts'] = true;
}
$petsland_ppp = petsland_get_theme_option('posts_per_page');
if ((int) $petsland_ppp != 0)
	$petsland_args['posts_per_page'] = (int) $petsland_ppp;
// Make a new main query
$GLOBALS['wp_the_query']->query($petsland_args);


// Add internal query vars in the new query!
if (is_array($petsland_content) && count($petsland_content) == 2) {
	set_query_var('blog_archive_start', $petsland_content[0]);
	set_query_var('blog_archive_end', $petsland_content[1]);
}

get_template_part('index');
?>